#include "affichage.h"

long aff_init(t_affichage *aff)
{
    char str[255];
    if (SDL_Init(SDL_INIT_VIDEO | SDL_INIT_TIMER) == -1) {return 0;} //Initialise la SDL
    if (TTF_Init() == -1) {return 0;}//Initialise SDL-ttf pour pouvoir crire du texte

    putenv("SDL_VIDEO_WINDOW_POS=center"); //pour centrer la fentre
    sprintf(str,"%s%s","ressources/","icon.png");
    SDL_WM_SetIcon(IMG_Load(str),NULL);

    aff->ecran = SDL_SetVideoMode(RESOLUTION_X, RESOLUTION_Y, 32, SDL_HWSURFACE | SDL_DOUBLEBUF); //Rservation mmoire pour la fentre et mise en place de la fentre
    if (aff->ecran == NULL) {return 0;}
    SDL_WM_SetCaption(TITRE, NULL); //On donne un titre  la fentre

    aff->police_normale = TTF_OpenFont(POLICE_TEXTE, POLICE_TAILLE_NORMALE); //Chargement de la police d'criture
    if (aff->police_normale == NULL) {return 0;}

    //Affichage d'une fentre noire avec les instructions
    SDL_FillRect(aff->ecran, NULL, SDL_MapRGB(aff->ecran->format, 0, 0, 0));
    afficher_message(aff->ecran, "        ===  Kaaptur  ===", aff->police_normale, 100, 100, 255);
    afficher_message(aff->ecran, " ", aff->police_normale, 100, 100, 255);
    afficher_menu(aff->ecran, aff->police_normale);
    afficher_message(aff->ecran, " ", aff->police_normale, 100, 100, 255);
    SDL_Flip(aff->ecran);
    aff->dernier_affichage = SDL_GetTicks();
    return 1;
}

void aff_quit(t_affichage *aff)
{
    TTF_CloseFont(aff->police_normale); //On libre la memoire alloue pour la police
    TTF_Quit();
    SDL_Quit();
}

void afficher_message(SDL_Surface *ecran, char *txt, TTF_Font *police, long rouge, long vert, long bleu)
{
    SDL_Surface *texte; //Contient le texte sous forme d'image  copier sur la destination (ecran)
    SDL_Rect position; //Contient les paramtres de position pour les diffrents affichages  effectuer
    SDL_Color couleur; //Contient la couleur du texte  afficher

    if(txt[0] == 0) {return;} //S'il n'y a rien  crire on termine tout de suite
    //Convertit le texte en une image  coller sur ecran
    couleur.r = rouge;
    couleur.g = vert;
    couleur.b = bleu;
    texte = TTF_RenderText_Blended(police, txt, couleur); //crit le texte
    //Scroll de ecran
    position.x = 0;
    position.y = texte->h;
    position.w = ecran->w;
    position.h = ecran->h - texte->h;
    SDL_BlitSurface(ecran, &position, ecran, NULL);
    //On efface la dernire ligne (sans compter celle de saisie)
    position.x = 0;
    position.y = ecran->h - 2 * texte->h;
    position.w = ecran->w;
    position.h = texte->h;
    SDL_FillRect(ecran, &position, SDL_MapRGB(ecran->format, 0, 0, 0));
    //Affichage du nouveau texte
    SDL_BlitSurface(texte, NULL, ecran, &position);
    //On efface l'image du texte
    SDL_FreeSurface(texte);
    return;
}

void afficher_saisie(SDL_Surface *ecran, char *txt, TTF_Font *police)
{
    SDL_Surface *texte; //Contient le texte sous forme d'image  copier sur la destination (ecran)
    SDL_Rect position, pos_texte; //Contient les paramtres de position pour les diffrents affichages  effectuer
    SDL_Color couleur; //Contient la couleur du texte  afficher

    if(txt[0] == 0) {return;} //S'il n'y a rien  crire on termine tout de suite
    //Convertit le texte en une image  coller sur ecran
    couleur.r = 255;
    couleur.g = 255;
    couleur.b = 255;
    texte = TTF_RenderText_Blended(police, txt, couleur); //crit le texte
    //On efface la ligne de saisie
    position.x = 0;
    position.y = ecran->h - texte->h;
    position.w = ecran->w;
    position.h = texte->h;
    SDL_FillRect(ecran, &position, SDL_MapRGB(ecran->format, 0, 0, 0));
    //Affichage du nouveau texte
    pos_texte.x = texte->w - ecran->w; //Si le texte est plus long que la fentre on affiche que la fin
    if(pos_texte.x < 0) {pos_texte.x = 0;}
    pos_texte.y = 0;
    pos_texte.w = ecran->w;
    pos_texte.h = texte->h;
    SDL_BlitSurface(texte, &pos_texte, ecran, &position);
    //On efface l'image du texte
    SDL_FreeSurface(texte);
    return;
}

void afficher_menu(SDL_Surface *ecran, TTF_Font *police)
{
    afficher_message(ecran, "Commandes serveur :", police, 100, 100, 255);
    afficher_message(ecran, "   - \"lancer\" : dmarre le serveur.", police, 100, 100, 255);
    afficher_message(ecran, "   - \"map = XXXX\" : charge la map XXXX.", police, 100, 100, 255);
    afficher_message(ecran, "   - \"charger = XXXX\" : charge la partie XXXX.", police, 100, 100, 255);
    afficher_message(ecran, "   - \"port = XXXX\" : change le port d'coute (par dfaut : 4444).", police, 100, 100, 255);
    afficher_message(ecran, "   - \"dist_inc = XXXX\" : change la distance de dcouverte du terrain.", police, 100, 100, 255);
    afficher_message(ecran, "   - \"dist_vis = XXXX\" : change la distance de visibilit.", police, 100, 100, 255);
    afficher_message(ecran, "   - \"nbr_chevalier = XXXX\" : change le nombre de chevaliers.", police, 100, 100, 255);
    afficher_message(ecran, "   - \"nbr_pcore = XXXX\" : change le nombre de pcores.", police, 100, 100, 255);
    afficher_message(ecran, "   - \"nbr_claireur = XXXX\" : change le nombre de claireurs.", police, 100, 100, 255);
    afficher_message(ecran, "   - \"envoyer  nXXXX : message\" : envoie le message au joueur nXXXX (ou 'nXXXX' = 'tous').", police, 100, 100, 255);
    afficher_message(ecran, "   - \"aide\" : affiche les commandes.", police, 100, 100, 255);
    afficher_message(ecran, "   - \"quitter\" : termine le programme.", police, 100, 100, 255);
    return;
}
